
#version 430 core
layout (location = 0) in vec3 fragPosition;
layout (location = 1) in vec3 noiseCoords;
layout (location = 2) in vec3 fragNormal;
layout (location = 3) in vec2 staticNoiseCoords;

layout (location = 0) out vec4 gAlbedoAlpha;
layout (location = 1) out vec4 gPhysical;

uniform float time;

float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }

float noise(vec3 x) {
	const vec3 step = vec3(110, 241, 171);

	vec3 i = floor(x);
	vec3 f = fract(x);
 
	// For performance, compute the base input to a 1D hash from the integer part of the argument and the 
	// incremental change to the 1D based on the 3D -> 1D wrapping
    float n = dot(i, step);

	vec3 u = f * f * (3.0 - 2.0 * f);
	return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y),
               mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z);
}

#define NUM_OCTAVES 5

float fbm ( in vec3 _st) {
    float v = 0.0;
    float a = 0.5;
    vec3 shift = vec3(100.0);
    // Rotate to reduce axial bias
    mat2 rot = mat2(cos(0.5), sin(0.5),
                    -sin(0.5), cos(0.50));
    for (int i = 0; i < NUM_OCTAVES; ++i) {
        v += a * noise(_st);
        _st = _st * 2.0 + shift;
        a *= 0.5;
    }
    return v;
}

float linearize_depth(float d,float zNear,float zFar)
{
  float z_n = 2.0 * d - 1.0;
  return 2.0 * zNear * zFar / (zFar + zNear - z_n * (zFar - zNear));
}

uniform mat4 VPW;

uniform mat4 worldMatrix;

uniform vec3 cameraPosition;

uniform vec3 starColorPrimary;
uniform vec3 starColorSecondary;

uniform int screenWidth;
uniform int screenHeight;

layout (binding = 0) uniform sampler2D depthTexture; 

uniform sampler2D noiseTex;

vec4 integrate( in vec4 sum, in float den, float atmoDepth, vec3 rayPos)
{
	vec3 albedo = mix(starColorPrimary, starColorSecondary, atmoDepth);

	vec4 col = vec4(albedo, den);

    // front to back blending    
    col.a *= 0.4;
    col.rgb *= col.a;
    return sum + col*(1.0-sum.a);
}


void main() {

	vec3 derp = vec3(1.0);

	float transparency = 0.0;
	
	vec3 rayPosition;
	float tempTransparency = 0.0;

	vec3 rayDirection = normalize(fragPosition - cameraPosition);

	vec4 sum = vec4(0.0);

	vec2 coords;
	coords.x = (gl_FragCoord.x / screenWidth); // this was the demon tweak
	coords.y = (gl_FragCoord.y / screenHeight);

	float sceneDepth = texture(depthTexture, coords.xy).w;

	float particleDepth = linearize_depth(gl_FragCoord.z, 1.0, 6000.0f);	
	float d = abs(sceneDepth - particleDepth);


	if(d < 300.0f){
		discard;
	}

	for(int i = 0; i < 30; i++){
	
		rayPosition = fragPosition + (rayDirection * float(i) * 3.0);


		if(length(rayPosition) < 200.0f){
			break;
		}if(length(rayPosition) > 220.0f){
			break;
		}

		vec4 rayInVP = VPW * vec4(rayPosition, 1.0);

		rayInVP.xyz = (rayInVP.xyz / rayInVP.w) * 0.5 + 0.5;

		float normalizedRayDepth = linearize_depth(rayInVP.z, 1.0, 6000);  

		gAlbedoAlpha = vec4(derp, 1.0);
		 
		float cutoffAddition = 1.0;
		float rayPosLength = length(rayPosition - worldMatrix[3].xyz);
		
		float cutoffAmount = 0.0;

		cutoffAmount = -0.2 + (rayPosLength - 200.0) / 20.0f;

		cutoffAmount = clamp(cutoffAmount, 0.01, 1.0);

		float noiseVal = fbm(rayPosition / 26.0f);

		noiseVal*= abs(sin(time + noiseVal * 10.0f));

		tempTransparency = noiseVal;
		tempTransparency -= cutoffAmount;
		tempTransparency *= 1 / (1 - cutoffAmount);
		tempTransparency = clamp(tempTransparency, 0.0, 1.0);

		//transparency += tempTransparency * cutoffAddition / 5.0f;

		float normalizedAtmoDepth = (rayPosLength - 200) / 20.0f;

		sum = integrate(sum, tempTransparency * cutoffAddition, normalizedAtmoDepth, rayPosition); 	

	}


	sum.a = sum.a;

	gAlbedoAlpha = sum;
	gPhysical = vec4(0.0);
}
